function getNearbyBlockTypes(bot) {
    // Find all blocks within the maxDistance radius
    const blocks = bot.findBlocks({
      maxDistance: 32,
      count: 1000, // Adjust the count to the maximum number of blocks to retrieve
      matching: (block) => block.name !== 'air' // Ignore air blocks
    });
  
    // Get block types and remove duplicates
    const blockTypes = [...new Set(blocks.map(pos => bot.blockAt(pos).name))];
  
    console.log('Nearby block types:', blockTypes);
  }